/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13;
//ESCA*JAVA0246

import java.io.IOException;
import java.util.Date;
import java.util.Vector;

import djbuch.kapitel_06.DemoTools;
import djbuch.kapitel_06.GC;
import junit.framework.TestCase;
import lotus.domino.Database;
import lotus.domino.DateTime;
import lotus.domino.Document;
import lotus.domino.Item;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.NotesThread;
import lotus.domino.Session;

/**
 * @author Thomas Ekert
 * @see DJCacheDocument
 */
public class DJCacheDocumentTest extends TestCase {

	private Session session = null;
	private Database db = null;
	private Document doc = null;
	private static final String PASSWORD = "geheim";
	private static final String HOST = null;//"www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = null;//"Thomas Ekert/DJBUCH";	//null fr lokale Session
	
	/**
	 * Testet das DJCacheDocument funktional und
	 * fhrt PerformanceTests im Vergleich zum lotus.domino.Document durch
	 *
	 */
	public void testDJCacheDocument () {
		try {
			doc.save (true,false);
			DJCacheDocument cacheDoc = new DJCacheDocument(doc);
			allTypes ("<diesesItemGibtEsNicht>", doc, cacheDoc);
			cacheDoc.appendItemValue ("drei", 3);
			insertItems (session, doc,"einfachesItem");
			insertItems (session, cacheDoc,"einfachesItem");
			allTypes ("einfachesItem", doc, cacheDoc);
			insertItemVector (session, doc,"vectorItem");
			insertItemVector (session, cacheDoc,"vectorItem");
			allTypes ("vectorItem", doc, cacheDoc);
			//System.out.println (cacheDoc.toString());
			//Performancetest new DJCacheDocument
			long L = System.currentTimeMillis();
			for (int i = 0; i < STRESS_COUNT; i++) {
				cacheDoc = new DJCacheDocument(doc);
			}
			System.out.println ("\n" + STRESS_COUNT + " neue DJCacheDocument erstellen: " + (System.currentTimeMillis()-L) + "ms");
			//Performancetest new Document
			L = System.currentTimeMillis();
			for (int i = 0; i < STRESS_COUNT; i++) {
				Document newDoc = doc.copyToDatabase(db);
				GC.recycle(newDoc);
			}
			System.out.println (STRESS_COUNT + " neue Document erstellen: " + (System.currentTimeMillis()-L) + "ms");
			//Performancetest DJCacheDocument.getItemValue
			Vector v = cacheDoc.getAllItemNames();
			int count = v.size();
			L = System.currentTimeMillis();
			for (int i = 0; i < STRESS_COUNT; i++) {
				for (int m = 0; m < v.size(); m++) {
					cacheDoc.getItemValue((String)v.elementAt(m));
				}
			}
			System.out.println ("\n" + STRESS_COUNT + " x "+ count + " DJCacheDocument.getItemValue Operationen: " + (System.currentTimeMillis()-L) + "ms");
			//Performancetest Document.getItemValue
			v = cacheDoc.getAllItemNames();
			L = System.currentTimeMillis();
			for (int i = 0; i < STRESS_COUNT; i++) {
				for (int m = 0; m < v.size(); m++) {
					doc.getItemValue((String)v.elementAt(m));
				}
			}			
			System.out.println (STRESS_COUNT + " x "+ count + " Document.getIemValue Operationen: " + (System.currentTimeMillis()-L) + "ms");
				//Values zur weiteren Verwendung vorladen
			v = cacheDoc.getAllItemNames();
			Vector values = new Vector();
			for (int m = 0; m < v.size(); m++) {
				values.add ((doc.getItemValue((String)v.elementAt(m))).toString());
			}
			//Performancetest DJCacheDocument.replaceItemValue
			L = System.currentTimeMillis();
			for (int i = 0; i < STRESS_COUNT; i++) {
				for (int m = 0; m < v.size(); m++) {
					cacheDoc.replaceItemValue((String)v.elementAt(m),(String)values.elementAt(m));
				}
			}			
			System.out.println ("\n" + STRESS_COUNT + " x "+ count + " DJCacheDocument.replaceIemValue Operationen: " + (System.currentTimeMillis()-L) + "ms");
			//Performancetest Document.replaceItemValue
			L = System.currentTimeMillis();
			v = cacheDoc.getAllItemNames();
			for (int i = 0; i < STRESS_COUNT; i++) {
				for (int m = 0; m < v.size(); m++) {
					doc.replaceItemValue((String)v.elementAt(m),(String)values.elementAt(m));
				}
			}			
			System.out.println (STRESS_COUNT + " x "+ count + " Document.replaceIemValue Operationen: " + (System.currentTimeMillis()-L) + "ms");

		} catch (Exception e) {
			e.printStackTrace();
			assertTrue("Exception aufgetreten", false);
		}
		System.out.println ("Teste DJCacheDocument done.");
	}
	
	/**
	 * Testet die SubKlasse FieldNames in DJCacheDocument
	 */
	public void testFieldNames () {
		DJCacheDocument cacheDoc=null;
		try {
			cacheDoc = new DJCacheDocument(doc);
			DJCacheDocument.FieldNames fn = cacheDoc.new FieldNames();
			assertFalse (fn.hasName("nix"));
			assertFalse (fn.hasName(""));
			assertFalse (fn.hasName (null));
			allNames (fn, "Neu");
			allNames (fn, "neU");
			allNames (fn, "n e u");
			allNames (fn, "n!eu!0");
			assertEquals (null, fn.addName(null));
			fn = cacheDoc.new FieldNames();
			assertFalse (fn.hasName(null));
			fn.addName("a");
			fn.addName("a");
			fn.addName("b");
			assertTrue ("[a, b]".equals (fn.getAllNames().toString()) || "[b, a]".equals (fn.getAllNames().toString()));
		} catch (NotesException e) {
			e.printStackTrace();
			assertTrue("Exception aufgetreten", false);
		}
		System.out.println ("Teste FieldNames done.");
	}
	
	/**
	 * Gleicht ber einen assert jeweils das Verhalten zwischen 
	 * lotus.domino.Document und DJCacheDocument
	 * gegeneinander ab. Dies wird fr die Methoden 
	 * getItemValueString
	 * getItemValueInteger
	 * getItemValueDouble
	 * getItemValue
	 * getItemValueDateTimeArray
	 * durchgefhrt und zwar jeweils fr alle diese Methoden gegen Felder
	 * vom Typ String, Integer, Double, DateTime und jeweils Vectoren solcher Typen.
	 * Folglich wird jede der Methoden auf jeden Datentyp angewendet.
	 * Die hierfr bentigten Items haben die Feldnamen aus dem Array types
	 * und werden in den Methoden insertItems und insertItemVector erzeugt,
	 * wobei diese beiden Methoden jeweils doppelt fr lotus.domino.Document
	 * und fr DJCacheDocument vorliegen.
	 * @param name
	 * @param dominoDoc
	 * @param cacheDoc
	 * @throws NotesException
	 */
	private void allTypes (String name, Document dominoDoc, DJCacheDocument cacheDoc) throws NotesException {
		System.out.println ("\n\nTeste alle getItem Methoden fr Feld " + name);
		for (int k = 0; k < types.length; k++) {
			String fieldname = name+types[k];
			System.out.println ("\tTeste getItemValueString gegen Typ " + fieldname);
			assertEquals (dominoDoc.getItemValueString (fieldname), cacheDoc.getItemValueString(fieldname));
			System.out.println ("\tTeste getItemValueInteger gegen Typ " + fieldname);
			assertEquals (dominoDoc.getItemValueInteger (fieldname), cacheDoc.getItemValueInteger(fieldname));
			System.out.println ("\tTeste getItemValueDouble gegen Typ " + fieldname);
			assertEquals (dominoDoc.getItemValueDouble(fieldname), cacheDoc.getItemValueDouble(fieldname), 0.000001);
			System.out.println ("\tTeste getItemValue gegen Typ " + fieldname);
			if (dominoDoc.getFirstItem(fieldname)!= null && dominoDoc.getFirstItem(fieldname).getType()==Item.DATETIMES) {
				Vector domino = DJCacheDocument.toJavaDate(dominoDoc.getItemValue(fieldname));
				Vector cache = cacheDoc.getItemValue(fieldname);
				assertEquals (domino.size(),cache.size());				
				for (int m = 0; m < domino.size(); m++) {
					assertEquals(0, ((Date) domino.elementAt(m))
							.compareTo(((Date) cache.elementAt(m))),10);
				}
			} else {
				assertEquals (dominoDoc.getItemValue (fieldname), cacheDoc.getItemValue(fieldname));
			}
			System.out.println ("\tTeste hasItem");
			assertEquals (dominoDoc.hasItem(fieldname), cacheDoc.hasItem(fieldname));
			System.out.println ("\tTeste getItemValueDateTimeArray gegen Typ " + fieldname);
			try {
				Vector cacheDT = cacheDoc.getItemValueDateTimeArray(fieldname, session);
				Vector dominoDT = dominoDoc.getItemValueDateTimeArray(fieldname);
				for (int i=0; i < dominoDT.size(); i++) {
					assertEquals(0, ((DateTime) dominoDT.elementAt(i))
							.timeDifference((DateTime) cacheDT.elementAt(i)));
				}
			} catch (NotesException expected) {
				try {
					Vector dominoDT = dominoDoc.getItemValueDateTimeArray(fieldname);
					assertTrue ("Wenn das domino Doc eine exception wirft, dann auch das cacheDoc", false);
				} catch (NotesException expectedFollowUP) {
					assertTrue(true);
				}
			}
		}
	}
	
	/**
	 * Erzeugt im Document doc je ein Item mit Namen name+<<i>> (i = 0..5)<br>
	 * jeweils mit den Datentypen Integer, Double, String, DateTime, Custom,<br>
	 * Custom (als ByteArray)
	 * @param session
	 * @param doc
	 * @param name
	 * @throws NotesException
	 * @throws IOException
	 */
	private static void insertItems (Session session, Document doc, String name) throws NotesException {
		doc.replaceItemValue(name+types[0], new Integer (-3));
		doc.replaceItemValue(name+types[1], new Double (-1.5));
		doc.replaceItemValue(name+types[2], "mein String");
		DateTime dt = session.createDateTime ("Yesterday 11:35:07");
		doc.replaceItemValue(name+types[3], dt);
		/*CustomClass custom = new CustomClass("Vorname Nachname", Calendar
				.getInstance().getTime());
		doc.replaceItemValueCustomData (name+types[4], TYPE_NAME, custom);
		doc.replaceItemValueCustomDataBytes (name+types[5], TYPE_NAME, custom.toString().getBytes());
		*/
	}

	private static void insertItems (Session session, DJCacheDocument doc, String name) throws NotesException {
		doc.replaceItemValue(name+types[0], new Integer (-3));
		doc.replaceItemValue(name+types[1], new Double (-1.5));
		doc.replaceItemValue(name+types[2], "mein String");
		DateTime dt = session.createDateTime ("Yesterday 11:35:07");
		doc.replaceItemValue(name+types[3], dt);
		/*CustomClass custom = new CustomClass("Vorname Nachname", Calendar
				.getInstance().getTime());
		doc.replaceItemValueCustomData (name+types[4], TYPE_NAME, custom);
		doc.replaceItemValueCustomDataBytes (name+types[5], TYPE_NAME, custom.toString().getBytes());
		*/
	}
	
	/**
	 * Erzeugt im Document doc je ein Item mit Namen name+<<i>> (i = 0..5)<br>
	 * jeweils mit Vectoren der Datentypen Integer, Double, String, DateTime, Custom,<br>
	 * Custom (als ByteArray)
	 * @see insertitems (Session, Document, String)
	 * @param session
	 * @param doc
	 * @param name
	 * @throws NotesException
	 * @throws IOException
	 */
	private static void insertItemVector (Session session, Document doc, String name) throws NotesException {
		Vector v = new Vector();
		v.add(new Integer (3));
		v.add(new Integer (4));
		v.add(new Integer (-3));
		v.add(new Integer (-4));
		doc.replaceItemValue(name+types[0], v);
		v = new Vector();
		v.add(new Double (2.2));
		v.add(new Double (2.5));
		v.add(new Double (-2.2));
		v.add(new Double (-2.5));
		doc.replaceItemValue(name+types[1], v);
		v = new Vector();
		v.add("Wert a");
		v.add("Wert b");		
		doc.replaceItemValue(name+types[2], v);
		
		/*Item item = doc.getFirstItem (name+types[2]);
		item.appendToTextList("Wert c via append");*/
		v = new Vector();
		DateTime dt = session.createDateTime ("Yesterday 11:35:07");
		v.add(dt);
		dt = session.createDateTime("Today");
		v.add(dt);
		dt = session.createDateTime("17.07.2007");
		v.add(dt);
		doc.replaceItemValue(name+types[3], v);		
		/*
		v = new Vector();
		CustomClass custom = new CustomClass("Vorname1 Nachname1", Calendar
				.getInstance().getTime());
		v.add (custom);
		custom = new CustomClass("Vorname2 Nachname2", Calendar
				.getInstance().getTime());		
		doc.replaceItemValueCustomData (name+types[4], TYPE_NAME, v);
		//replaceItemValueCustomDataBytes macht hier keinen Sinn.
		 */
	}
	
	private static void insertItemVector (Session session, DJCacheDocument doc, String name) throws NotesException, IOException {
		Vector v = new Vector();
		v.add(new Integer (3));
		v.add(new Integer (4));
		v.add(new Integer (-3));
		v.add(new Integer (-4));
		doc.replaceItemValue(name+types[0], v);
		v = new Vector();
		v.add(new Double (2.2));
		v.add(new Double (2.5));
		v.add(new Double (-2.2));
		v.add(new Double (-2.5));
		doc.replaceItemValue(name+types[1], v);
		v = new Vector();
		v.add("Wert a");
		v.add("Wert b");		
		doc.replaceItemValue(name+types[2], v);
		
		/*Item item = doc.getFirstItem (name+types[2]);
		item.appendToTextList("Wert c via append");*/
		v = new Vector();
		DateTime dt = session.createDateTime ("Yesterday 11:35:07");
		v.add(dt);
		dt = session.createDateTime("Today");
		v.add(dt);
		dt = session.createDateTime("17.07.2007");
		v.add(dt);
		doc.replaceItemValue(name+types[3], v);		
		/*
		v = new Vector();
		CustomClass custom = new CustomClass("Vorname1 Nachname1", Calendar
				.getInstance().getTime());
		v.add (custom);
		custom = new CustomClass("Vorname2 Nachname2", Calendar
				.getInstance().getTime());		
		doc.replaceItemValueCustomData (name+types[4], TYPE_NAME, v);
		//replaceItemValueCustomDataBytes macht hier keinen Sinn.
		 */
	}
	
	
	private static void allNames (DJCacheDocument.FieldNames fn, String key) {
		fn.addName(key);
		assertTrue (fn.hasName(key));
		fn.removeName(key);
		assertFalse (fn.hasName(key));
		assertEquals (key.toLowerCase(),fn.addName (key));
		assertEquals (key.toLowerCase()+DJCacheDocument.FieldNames.SIGN+1,fn.addName (key.toUpperCase()));
		assertEquals (key.toLowerCase()+DJCacheDocument.FieldNames.SIGN+2,fn.addName (key.toLowerCase()));
		assertTrue (fn.hasName (key.toLowerCase()));
		assertTrue (fn.hasName (key.toUpperCase()));
		assertTrue (fn.hasName (key));
		assertTrue (fn.hasName (key,1));
		assertTrue (fn.hasName (key.toUpperCase(),1));
		assertTrue (fn.hasName (key,2));
		assertFalse (fn.hasName (key,3));
		assertFalse (fn.hasName (key.toLowerCase(),3));
		assertEquals (3, fn.getNameCount(key));
		Vector v = fn.getNames(key);
		assertFalse (v == null);
		assertEquals (3,v.size());
		//System.out.println (fn.getAllNames());
		for (int i = 0; i<v.size(); i++){
			assertEquals (key.toLowerCase()+ (i==0?"":""+DJCacheDocument.FieldNames.SIGN+i),(String)v.elementAt(i));
		}
		fn.removeName(key);
		assertEquals (0, fn.getNameCount(key));
		assertEquals (null, fn.getNames(key));
		assertFalse (fn.hasName (key,0));
		assertFalse (fn.hasName (key,1));
		assertFalse (fn.hasName (key,2));
		assertFalse (fn.hasName (key.toUpperCase(),2));
		assertFalse (fn.hasName (key,3));
		assertFalse (fn.hasName(key));
	}
	
	protected void setUp() throws Exception {
		super.setUp();
		if (HOST == null) {
			NotesThread.sinitThread();
		}
		session=NotesFactory.createSession (HOST, USER, PASSWORD);
		db = session.getDatabase(session.getServerName(), "djbuch/djbuch.nsf");
		doc = DemoTools.createDoc(db,"FO_document_k13", "JUNIT", "Testdokument",null);
	}

	protected void tearDown() throws Exception {
		super.tearDown();
		doc.remove(true);
		GC.recycle(doc);
		GC.recycle(db);
		GC.recycle (session);
		if (HOST == null) {
			NotesThread.stermThread();
		}
	}
	private static final String [] types = {"Integer", "Double", "String", "DateTime"};
	private static final int STRESS_COUNT = 1000;
}
